const http = require('http');
const fs = require('fs');
const url = require('url');

const hostname = '127.0.0.1';
const port = 3000;

const server = http.createServer((req, res) => {
  res.statusCode = 200;
  res.setHeader('Content-Type', 'text/html;charset=utf-8');

  const urlObject = url.parse(req.url, true);
  const queryObject = urlObject.query;

  if (req.url.endsWith("/favicon.ico")) {
    res.end();
    return;
  }

  let path = urlObject.pathname.split("/");
  let modName = path[path.length - 1] === "" ? path[path.length - 2] : path[path.length - 1];
  
  if (modName === "") {
    res.end(`modName=="${modName}"`);
  } else {
    if (fs.existsSync(`./${modName}/${modName}.js`)) {
      let mod = require(`./${modName}/${modName}.js`);
      res.end(mod.ff(queryObject));
    } else {
      res.end(`Wrong path: "./${modName}/${modName}.js" does not exist.`);
    }
  }
});

server.listen(port, hostname, () => {
  console.log(`Server running at http://${hostname}:${port}/`);
});