const fs = require('fs');
const path = require('path');
const sqlite3 = require('sqlite3').verbose();

const dbFile = path.join(__dirname, '..', 'database.db');
const schemaFile = path.join(__dirname, '..', 'DB.TXT');

const ff = () => {
    const db = new sqlite3.Database(dbFile);
    const schema = fs.readFileSync(schemaFile, 'utf-8');
    return new Promise((resolve, reject) => {
        db.exec(schema, (err) => {
            if (err) {
                reject('Error creating table');
            } else {
                resolve('Table created successfully');
            }
        });
        db.close();
    });
};

module.exports = (query) => ff().then(result => `<p>${result}</p>`).catch(err => `<p>${err}</p>`);
