const fs = require("fs");
const mysql = require('mysql');
const util = require('util');

function createStyledTableHTML(data) {
    if (data.length === 0) {
        return '<p>No data available</p>';
    }

    let tableHTML = `
    <table style="border-collapse: collapse; width: 100%;">
        <thead style="background-color: #f2f2f2;">
            <tr>
                ${Object.keys(data[0]).map(column => `<th style="border: 1px solid #ddd; padding: 8px;">${column}</th>`).join('')}
            </tr>
        </thead>
        <tbody>
            ${data.map(row => `
                <tr>
                    ${Object.values(row).map(value => `<td style="border: 1px solid #ddd; padding: 8px;">${value}</td>`).join('')}
                </tr>`).join('')}
        </tbody>
    </table>`;
    
    return tableHTML;
}

function parseDatabaseSchema(filePath) {
    const fileContent = fs.readFileSync(filePath, "utf-8").trim();
    const lines = fileContent.split("\n");

    if (lines.length < 2) {
        throw new Error("Invalid DB file format");
    }

    const tableName = lines[0].trim();
    const columns = lines.slice(1).map(line => line.trim()).join(", ");
    
    if (!tableName || !columns) {
        throw new Error("Invalid table schema in DB file");
    }

    return { tableName, columns };
}

async function handleRequest(queryParams) {
    console.log("Received queryParams:", queryParams);

    if (Object.keys(queryParams).length === 0) {
        return fs.readFileSync(__dirname + "/index.html");
    }

    if (queryParams.action === "createTable") {
        let parsedDB;
        try {
            parsedDB = parseDatabaseSchema(__dirname + "/db.txt");
        } catch (error) {
            console.error('Error parsing DB file:', error);
            return `Error: ${error.message}`;
        }

        const { tableName, columns } = parsedDB;
        const createTableSQL = `CREATE TABLE ${tableName} (${columns})`;
        console.log("Executing SQL:", createTableSQL);

        const connection = mysql.createConnection({
            host: 'localhost',
            user: 'khizha_harkaviy',
            password: 'vagkyt-xirnA5-bysnad',
            database: 'khizha_harkaviy'
        });

        connection.connect(error => {
            if (error) {
                console.error('Error connecting to MySQL database:', error);
                return "Error connecting to MySQL database";
            }
            console.log('Connected to MySQL database!');
        });

        return new Promise((resolve, reject) => {
            connection.query(createTableSQL, error => {
                connection.end();
                if (error) {
                    console.error('Error creating table:', error);
                    reject("Error creating table");
                } else {
                    console.log("Table created successfully");
                    resolve("Table created successfully");
                }
            });
        });

    } else if (queryParams.tableName) {
        const tableName = queryParams.tableName;
        console.log("Looking for table:", tableName);
        const selectSQL = `SELECT * FROM ${tableName}`;
        console.log("Executing SQL:", selectSQL);

        const connection = mysql.createConnection({
            host: 'localhost',
            user: 'khizha_harkaviy',
            password: 'vagkyt-xirnA5-bysnad',
            database: 'khizha_harkaviy'
        });

        const query = util.promisify(connection.query).bind(connection);

        try {
            const results = await query(selectSQL);
            const htmlTable = createStyledTableHTML(results);
            connection.end();
            return `<html><body>${htmlTable}</body></html>`;
        } catch (error) {
            connection.end();
            console.error('Error fetching table data:', error);
            return `<html><body>Error fetching table data: ${error}</body></html>`;
        }
    } else {
        console.log("Missing table name in queryParams:", queryParams);
        return "Error: Missing table name.";
    }
}

console.log("Exporting function 'ff'");
exports.ff = handleRequest;