const fs = require("fs");
const http = require("http");
const stream = require("stream");
const {getDatabase,parseURL,writeDatabase,resoulveRoute} = require("../supplementaries");
const {loginResult} = require("./common_login_logic");

let litbank_routes = [
    {
        path: [],
        staticContent: "litbank/leader.html"
    },
    {
        path: ["login"],
        staticContent: "login_screen.html"
    },
    {
        path: ["loginResult"],
        dynamicContent: loginResult
    },
    {
        path: ["json_money"],
        dynamicContent: jsonMoney
    },
    {
        path: ["json_current_amount"],
        dynamicContent: jsonCurrentAmount,
    },
    {
        path: ["json_convert"],
        dynamicContent: jsonConvert,
    },

    // {
    //     path: ["catalogue"],
    //     staticContent: "catalogue.html",
    //     // fillContent: fillCatalogue,
    //     replace: [
    //         ["CATALOGUE_LIST",fillCatalogue]
    //     ]
    // },
    // {
    //     path: ["buy_now"],
    //     staticContent: "buy_now.html",
    //     // fillContent: FillBuyCredentials,
    //     replace: [
    //         ["BUY_CREDENTIALS",fillBuyCredentials]
    //     ]
    // }
]


function jsonMoney(req,res,parsed_url) {
    if (!checkSession(parsed_url)[0]) {return;}
    let [delimeter,names,values] = getDatabase("converts.csva");
    let pairs = [];
    values.forEach(v => {
        pairs.push([v[names[0]],v[names[1]],v[names[2]],v[names[3]]]);
    });
    res.setHeader("Content-Type","text/json");
    res.end(JSON.stringify(pairs));
}

function jsonCurrentAmount(req,res,parsed_url) {
        let session = checkSession(parsed_url);
        if (!session[0]) {return;}
        let login = session[1];
        
        let [delimeter,names,values] = getDatabase("values.csva");

        let my_bank = values.filter(v => v[names[0]]===login);

        res.setHeader("Content-Type","text/json");
        res.end(JSON.stringify(my_bank));
}

function jsonConvert(req,res,parsed_url) {
        res.setHeader("Content-Type","text/json");
        let session = checkSession(parsed_url);
        if (!session[0]) {return;}
        let login = session[1];
        
        let [v_delimeter,[NAME,UAH,EUR,USD],v_values] = getDatabase("values.csva");
        let [c_delimeter,[C_NAME,BUY,SELL,SHORTC_NAME],c_values] = getDatabase("converts.csva");
        let typeFrom = parsed_url.getParams.find(v => v[0]=="typeFrom");
        let typeTo = parsed_url.getParams.find(v => v[0]=="typeTo");
        let amount = parsed_url.getParams.find(v => v[0]=="amount");
        console.log(parsed_url.getParams);
        if (typeof typeFrom == "undefined" || typeof typeTo == "undefined" || typeof amount == "undefined") {
            res.end(JSON.stringify({result:"error"}));
            return;
        }
        typeFrom = typeFrom[1];
        typeTo = typeTo[1];
        amount = parseFloat(amount[1]);

        console.log(amount);

        if (typeFrom != "UAH" && typeTo != "UAH") {
            res.end(JSON.stringify({result:"error", message: "only to and from UAH is supported"}));
            return;
        }
        
        let my_bank_idx = v_values.findIndex(v => v[NAME]===login);
        if (typeof v_values[my_bank_idx] == "undefined") {
            res.end(JSON.stringify({result:"error"}));
            return;
        }
        if (v_values[my_bank_idx][typeFrom] < amount) {
            res.end(JSON.stringify({result:"error"}));
            return;
        }

        let gain = 0;

        if (typeFrom == "UAH") {
            gain = 1 / c_values.find(v => v[SHORTC_NAME] == typeTo)[SELL];
        } else {
            gain = c_values.find(v => v[SHORTC_NAME] == typeFrom)[BUY];
        }
        console.log(v_values);

        v_values[my_bank_idx][typeFrom] = (parseFloat(v_values[my_bank_idx][typeFrom] ) - amount).toFixed(2);
        v_values[my_bank_idx][typeTo] = (parseFloat(v_values[my_bank_idx][typeTo]) + amount * gain).toFixed(2);
        
        console.log(v_values);
        
        res.end(JSON.stringify(v_values[my_bank_idx]));  
        writeDatabase(v_delimeter,[NAME,UAH,EUR,USD],v_values,"values.csva");
}

function checkSession(parsed_url) {
    let [delimeter,names,values] = getDatabase("sessions.csva");
    let session = parsed_url.getParams.find(v => v[0]=="session");
    if (typeof session == "undefined") {
        return [false,null];
    }
    session = session[1];
    let filter = values.find(v => v[names[1]] === session);
    if (typeof filter !== "undefined") {
        return [true,filter[names[0]]];
    }
    return false;
}

module.exports.litbank_routes = litbank_routes;