const http = require('http');
const fs = require('fs');
const url = require('url');

const hostname = '127.0.0.3';
const port = 3000;

const catalogHolder = "!==catalog==!";
const orderedHolder = "!==ordered==!";
const errorHolder = "!==error==!";

function page(error) { 
    const page = fs.readFileSync("1.html", 'utf8');
    const db = JSON.parse(fs.readFileSync("db.json", 'utf8'));
    let catalog = '';
    let ordered = '';
    for(let i = 0; i < db.catalog.length; i ++) {
        catalog = catalog + `${db.catalog[i].name}  ${db.catalog[i].available_amount} pcs.  ${db.catalog[i].price} $ <br>`;
        ordered = ordered + `${db.catalog[i].name}  ${db.catalog[i].ordered_amount} pcs. <br>`;
    }
    return page.replace(catalogHolder, catalog).replace(orderedHolder, ordered).replace(errorHolder, error);

}
const server = http.createServer((req, res) => {
    res.writeHead(200, {'Content-Type': 'text/html'});

    let requestUrl = req.url;

    if (requestUrl === '/pupils/ens/') {
        res.end(page(""));
    } else if(requestUrl.includes("/pupils/ens/order")){
        const queryObject = url.parse(req.url, true).query;
        const name = queryObject.name;
        const amount = Number(queryObject.amount);

        const db = JSON.parse(fs.readFileSync("db.json", 'utf8'));

        let error = '';
        let productExist = false;
        for(let i = 0; i < db.catalog.length; i ++) {
            if(db.catalog[i].name == name){
                productExist = true;
                if(Number(db.catalog[i].available_amount) >= amount){
                    db.catalog[i].available_amount = Number(db.catalog[i].available_amount) - amount;
                    db.catalog[i].ordered_amount = Number(db.catalog[i].ordered_amount) + amount;
                } else {
                    error = `Not enough ${name}`;
                }
            }
        }
        if(!productExist) {
            error = `There is not such product ${name}`;
        }
        fs.writeFileSync("db.json", JSON.stringify(db));
        res.end(page(error));

    } else if (requestUrl === "/pupils/ens/favicon.ico") {
        ;
    } else {
        res.end("Invalid URL");
    }
}
);

server.listen(port, hostname, () => {
    console.log(`Server running at http://${hostname}:${port}/`);
});
