const http = require('http');
const fs = require('fs');
const url = require('url');
const path = require('path');

const hostname = '127.0.0.1';
const port = 3000;

function digit_sum(num) {
    return Math.abs(num).toString().replace(".", "").split("").reduce((sum, digit) => sum + Number(digit), 0);
}

function comparator(a, b) {
    return digit_sum(a) - digit_sum(b);
}

const server = http.createServer((req, res) => {
    const parsedUrl = url.parse(req.url, true);
    const pathname = parsedUrl.pathname;

    // Головна сторінка
    if (req.method === 'GET' && pathname === '/pupils/tereshchenko/') {
        fs.readFile(path.join(__dirname, 'public', 'index.html'), 'utf8', (err, data) => {
            if (err) {
                res.writeHead(500);
                return res.end('Error loading index.html');
            }
            res.writeHead(200, {'Content-Type': 'text/html'});
            res.end(data);
        });
    } else if (req.method === 'POST' && pathname === '/pupils/tereshchenko/sort/') {
        let body = '';
        req.on('data', chunk => {
            body += chunk.toString(); // Конвертуємо Buffer в string
        });
        req.on('end', () => {
            const requestData = JSON.parse(body);
            const sortedSequence = requestData.sequence.split(" ").map(Number).sort(comparator).join(" ");
            res.writeHead(200, {'Content-Type': 'application/json'});
            res.end(JSON.stringify({ sorted: sortedSequence }));
        });
    } else {
    res.writeHead(404, {'Content-Type': 'application/json'});
    res.end(JSON.stringify({ error: 'Not Found' }));
}

});

server.listen(port, hostname, () => {
    console.log(`Server running at http://${hostname}:${port}/`);
});
