// var http = require('http');
// var server = http.createServer(function(req, res) {
//     res.writeHead(200, {'Content-Type': 'text/plain'});
//     var message = 'Yes.It works!\n',
//         version = 'NodeJS ' + process.versions.node + '\n',
//         response = [message, version].join('\n');
//     res.end(response);
// });
// server.listen();
const http = require("http");
const url = require("url");
const fs = require("fs");

const server = http.createServer((req, res) => {
  const path = url.parse(req.url, true).pathname;

  if (path === "/pupils/sytnyk/") {
    fs.readFile("test.html", (err, data) => {
      if (err) {
        res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
        res.end("Internal Server Error");
      } else {
        res.writeHead(200, { "Content-Type": "text/html; charset=utf-8" });
        res.end(data);
      }
    });
  } else if (path === "/pupils/sytnyk/find") {
    const dataBase = fs.readFileSync("./data-base.txt", "utf-8");
    const sentences = dataBase.split(/[.;]\s*/);
    const nonEmptySentences = sentences.filter(
      (sentence) => sentence.trim() !== ""
    );

    const query = url.parse(req.url, true).query;
    const numbers = Array.isArray(query.numbers)
      ? query.numbers
      : [query.numbers];

    const sentencesWithNumbers = nonEmptySentences.filter((sentence) => {
      return numbers.find((number) =>
        sentence.toLowerCase().includes(number.toLowerCase())
      );
    });

    console.log(sentencesWithNumbers);

    res.writeHead(200, { "Content-Type": "text/plain; charset=utf-8" });
    if (query.numbers.length === 0) {
        res.end(`Ви не ввели нічого для пошуку`);
    } else if (sentencesWithNumbers.length === 0) {
      res.end(`По вашому запиту нічого не знайшлося`);
    } else {
      res.end(sentencesWithNumbers.join("\n"));
    }
  }
  else{
    res.end(`blabla ${path}`)
  }
});

const PORT = process.env.PORT || 3000;


server.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
