const http = require("http");
const url = require("url");
const fs = require("fs");

const server = http.createServer((req, res) => {
  const path = url.parse(req.url, true).pathname;

  if (path === "/pupils/sytnyk/") {
    fs.readFile("test.html", (err, data) => {
      if (err) {
        res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
        res.end("Internal Server Error");
      } else {
        res.writeHead(200, { "Content-Type": "text/html; charset=utf-8" });
        res.end(data);
      }
    });
  } else if (path === "/pupils/sytnyk/sort") {
    const query = url.parse(req.url, true).query;
    const string = query.a;
    const numbersArray = string.split(/[ ,;]/).map(Number).filter(Boolean); 
    const sortedNumbers = numbersArray.sort((a, b) => a - b);
    const sortedString = sortedNumbers.join(", ");

    res.writeHead(200, { "Content-Type": "text/plain; charset=utf-8" });
    res.end(`${sortedString}`);
  } else {
    res.end(`blabla ${path}`);
  }
});

const PORT = process.env.PORT || 3000;

server.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
