const http = require("http");
const url = require("url");
const fs = require("fs");

const server = http.createServer((req, res) => {
  const path = url.parse(req.url, true).pathname;

  if (req.method === "GET" && path === "/pupils/sytnyk/") {
    fs.readFile("test.html", (err, data) => {
      if (err) {
        res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
        res.end("Internal Server Error");
      } else {
        fs.readFile("db.json", "utf8", (err, jsonData) => {
          if (err) {
            console.error("Ошибка чтения файла:", err);
            res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
            res.end("Internal Server Error");
            return;
          }
          try {
            const dbData = JSON.parse(jsonData);
            const listItems = dbData.string
              .map((item, index) => `<li>${index + 1}. ${item}</li>`)
              .join("");
            const htmlString = data
              .toString()
              .replace(
                `<p id="db"></p>`,
                `<p id="db">Зміст бази данних:</p><ul>${listItems}</ul>`
              );

            res.writeHead(200, { "Content-Type": "text/html; charset=utf-8" });
            res.end(htmlString);
          } catch (parseError) {
            console.error("Ошибка парсинга JSON:", parseError);
            res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
            res.end("Internal Server Error");
          }
        });
      }
    });
  } else if (req.method === "POST" && path === "/pupils/sytnyk/add") {
    let body = "";
    req.on("data", (chunk) => {
      body += chunk.toString();
    });
    req.on("end", () => {
      const postData = decodeURIComponent(body);
      const addText = postData.split("=")[1];
      fs.readFile("db.json", "utf8", (err, jsonData) => {
        if (err) {
          console.error("Ошибка чтения файла:", err);
          res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
          res.end("Internal Server Error");
          return;
        }
        try {
          const dbData = JSON.parse(jsonData);
          dbData.string.push(addText);
          fs.writeFile("db.json", JSON.stringify(dbData), (err) => {
            if (err) {
              console.error("Ошибка записи файла:", err);
              res.writeHead(500, {
                "Content-Type": "text/plain; charset=utf-8",
              });
              res.end("Internal Server Error");
              return;
            }
            res.writeHead(302, { Location: "/pupils/sytnyk/" }); // перенаправляем обратно на главную страницу
            res.end();
          });
        } catch (parseError) {
          console.error("Ошибка парсинга JSON:", parseError);
          res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
          res.end("Internal Server Error");
        }
      });
    });
  } else if (req.method === "POST" && path === "/pupils/sytnyk/delete") {
    let body = "";
    req.on("data", (chunk) => {
      body += chunk.toString();
    });
    req.on("end", () => {
      const postData = decodeURIComponent(body);
      const addText = postData.split("=")[1];
      const indexToDelete = addText - 1
      fs.readFile("db.json", "utf8", (err, jsonData) => {
        if (err) {
          console.error("Ошибка чтения файла:", err);
          res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
          res.end("Internal Server Error");
          return;
        }
        try {
          const dbData = JSON.parse(jsonData);
          if(indexToDelete!==0){

            dbData.string.splice(indexToDelete, 1);
          }

          fs.writeFile("db.json", JSON.stringify(dbData), (err) => {
            if (err) {
              console.error("Ошибка записи файла:", err);
              res.writeHead(500, {
                "Content-Type": "text/plain; charset=utf-8",
              });
              res.end("Internal Server Error");
              return;
            }
            res.writeHead(302, { Location: "/pupils/sytnyk/" }); // перенаправляем обратно на главную страницу
            res.end();
          });
        } catch (parseError) {
          console.error("Ошибка парсинга JSON:", parseError);
          res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
          res.end("Internal Server Error");
        }
      });
    });
  } else {
    res.end(`blabla ${path}`);
  }
});

const PORT = process.env.PORT || 3000;

server.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
