const fs = require('fs');

function createTable(connection, callback) {
  fs.readFile('DB.TXT', 'utf8', (err, data) => {
    if (err) {
      callback("Error reading DB.TXT file");
      return;
    }

    connection.connect((error) => {
      if (error) {
        callback('Error connecting to MySQL database');
        return;
      }

      connection.query(data, (error) => {
        if (error) {
          callback('Error creating table');
        } else {
          callback('Table created successfully');
        }
        connection.end();
      });
    });
  });
}

exports.ff = createTable;
