const fs = require("fs");
const mysql = require('mysql');

function createTable(data) {
    if (data.length === 0) {
        return '<p>No data available</p>';
    }

    let table = '<div style="display: flex; justify-content: center;">';
    table += '<table style="border-collapse: collapse; width: 50%; margin-top: 20px; margin-bottom: 20px; background-color: #f2f2f2; border: 2px solid #ddd;">'; // Adjusted width and centered, added border and background color
    table += '<thead style="background-color: #8fbf6d; color: white;">';
    table += '<tr>';
    for (let key in data[0]) {
        table += `<th style="border: 1px solid #dddddd; text-align: left; padding: 8px;">${key}</th>`;
    }
    table += '</tr>';
    table += '</thead>';

    table += '<tbody>';
    data.forEach((row, index) => {
        table += `<tr ${(index % 2 === 0) ? 'style="background-color: #f9f9f9;"' : ''}>`;
        for (let key in row) {
            table += `<td style="border: 1px solid #dddddd; text-align: left; padding: 8px;">${row[key]}</td>`;
        }
        table += '</tr>';
    });
    table += '</tbody>';

    table += '</table>';
    table += '</div>';
    return table;
}


function createTableOrFetchData(queryObject) {
    if (Object.entries(queryObject).length === 0) {
        return fs.readFileSync(__dirname + "/index.html");
    } else if (queryObject.table === "table") {
        const fileContent = fs.readFileSync(__dirname + "/DB.txt", "utf-8");
        const fileData = fileContent.split(", ");
        const tableName = fileData[0];
        const amountOfColumns = Number(fileData[1]);

        let columns = fileData.slice(2, 2 + amountOfColumns).join(", ");
        const sql = `CREATE TABLE ${tableName}(${columns})`;

        console.log(sql);

        const connection = mysql.createConnection({
            host: 'localhost',
            user: 'khizha_hurtovyi',
            password: 'huhmok-2cekSo-hombub',
            database: 'khizha_hurtovyi'
        });

        connection.connect((error) => {
            if (error) {
                console.error('Error connecting to MySQL database:', error);
            } else {
                console.log('Connected to MySQL database!');
                connection.query(sql, (error) => {
                    if (error) {
                        console.error('Error creating table:', error);
                    } else {
                        console.log("Test table created");
                    }
                    connection.end();
                });
            }
        });

        return "Table created";
    } else if (queryObject.name) {
        return new Promise((resolve, reject) => {
            const tableName = queryObject.name;
            const sql = `SELECT * FROM ${tableName}`;

            const connection = mysql.createConnection({
                host: 'localhost',
                user: 'khizha_hurtovyi',
                password: 'huhmok-2cekSo-hombub',
                database: 'khizha_hurtovyi'
            });

            connection.connect((error) => {
                if (error) {
                    console.error('Error connecting to MySQL database:', error);
                    reject(error);
                } else {
                    console.log('Connected to MySQL database!');
                    connection.query(sql, (error, results) => {
                        if (error) {
                            console.error('Error fetching table data:', error);
                            reject(error);
                        } else {
                            console.log("Table data fetched successfully:", results);
                            connection.end();
                            resolve(results);
                        }
                    });
                }
            });
        }).then((results) => {
            return createTable(results);
        }).catch((error) => {

            console.error('Error:', error);
            return '<p>Error occurred</p>';
        });
    }
}

exports.ff = createTableOrFetchData;
