const http = require("http");
const fs = require("fs");
const mysql = require("mysql");

const hostname = "127.0.0.1";
const port = 3000;

const server = http.createServer((req, res) => {
  res.statusCode = 200;
  res.setHeader("Content-Type", "text/plain");
  res.end("Hello World! NodeJS :)\n");
});

server.listen(port, hostname, () => {
  console.log(`Server running at http://${hostname}:${port}/`);
});

// Reading table information from a JSON file
fs.readFile("table_info.json", "utf8", (err, data) => {
  if (err) {
    console.error("Error reading file:", err);
    return;
  }
  const tableInfo = JSON.parse(data);
  createTable(tableInfo);
});

function createTable(tableInfo) {
  const connection = mysql.createConnection({
    host: "localhost",
    user: "khizha_filchenkov",
    password: "bacjag-6xohmi-niKdun",
    database: "khizha_filchenkov",
  });

  connection.connect((error) => {
    if (error) {
      console.error("Error connecting to MySQL database:", error);
      return;
    }
    console.log("Connected to MySQL database!");

    let sql = `CREATE TABLE ${tableInfo.name} (`;
    for (let i = 0; i < tableInfo.fields.length; i++) {
      const field = tableInfo.fields[i];
      sql += `${field.name} ${field.type}`;
      if (field.length) {
        sql += `(${field.length})`;
      }
      if (i !== tableInfo.fields.length - 1) {
        sql += ", ";
      }
    }
    sql += ")";
    connection.query(sql, (error) => {
      if (error) {
        console.error("Error creating table:", error);
      }
      console.log(`${tableInfo.name} table created`);
      connection.end();
    });
  });
}