const http = require('http');
const fs = require('fs');
const url = require('url');

const hostname = '127.0.0.1';
const port = 3000;

function calculateSumOfNumbers (n) {
    n = '' + n;
    n = n.replace('.', '').replace(',', '').replace('-', '').split('');
    s = 0
    for (let i = 0; i < n.length; i++){
        s = s + Number(n[i]);
    }
    return s;
}

const server = http.createServer((req, res) => {
    res.writeHead(200, {'Content-Type': 'text/html'});

    let requestUrl = req.url;
    console.log(`Received request for: ${requestUrl}`);

    if (requestUrl === '/pupils/ens/') {
        res.end(fs.readFileSync("1.html", 'utf8'));
    } else if(requestUrl.startsWith("/pupils/ens/sequence")){
        const queryObject = url.parse(req.url, true).query;
        let arr = queryObject.sequence.split(" ");
        arr = arr.sort((a, b) => calculateSumOfNumbers(a)- calculateSumOfNumbers(b));
        res.end(`Sorted sequence: ${arr.join(" ")}`);
    } else if (requestUrl.endsWith("/favicon.ico")) {
        
    } else {
        res.end("Invalid URL");
    }
});

server.listen(port, hostname, () => {
    console.log(`Server running at http://${hostname}:${port}/`);
});