const http = require("http");
const url = require("url");
const fs = require("fs");
const querystring = require("querystring");
const crypto = require("crypto");
const { readJSONFile } = require("./functions.js");

function hash(password) {
  const hash = crypto.createHash("sha256");
  hash.update(password);
  return hash.digest("hex");
}

function setUserAndRedirect(res, location, user) {
  res.writeHead(302, {
    Location: location,
    "Set-Cookie": `username=${user.name}; Max-Age=3600; Path=/`,
  });
  res.end(`${user.name} `);
}

const server = http.createServer((req, res) => {
  const path = url.parse(req.url, true).pathname;
  const parsedUrl = url.parse(req.url, true);
  const cookieHeader = req.headers.cookie;

  const cookies = {};
  if (cookieHeader) {
    cookieHeader.split(";").forEach((cookie) => {
      const parts = cookie.split("=");
      const name = parts.shift().trim();
      const value = decodeURI(parts.join("="));
      cookies[name] = value;
    });
  }

  if (req.method === "GET" && path === "/pupils/sytnyk/") {
    if (!cookies.username) {
      res.writeHead(302, { Location: "/pupils/sytnyk/login" });
      res.end();
      return;
    }
    fs.readFile("test.html", (err, data) => {
      if (err) {
        res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
        res.end("Internal Server Error");
      } else {
        fs.readFile("db.json", "utf8", (err, jsonData) => {
          if (err) {
            res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
            res.end("Internal Server Error");
            return;
          }
          try {
            const dbData = JSON.parse(jsonData);
            const listItems = dbData.string
              .map((item, index) => `<li>${index + 1}. ${item}</li>`)
              .join("");
            const currenciesString = dbData.currensyToHryvnias
              .map((currency) => {
                return `${currency.currensy}: Купити - ${currency.buy}, Продати - ${currency.sell}<br>`;
              })
              .join("\n");
            const userBalanceElement = dbData.user.find(
              (element) => element.name === cookies.username
            );

            const balanceInHryvnias = userBalanceElement
              ? userBalanceElement.balanceInHryvnias
              : 0;
            const balanceInDollars = userBalanceElement
              ? userBalanceElement.balanceInDollars
              : 0;
            const balanceInEuros = userBalanceElement
              ? userBalanceElement.balanceInEuros
              : 0;

            const htmlString = data.toString().replace(
              `<p id="db"></p>`,
              `<p id="db">Зараз ви ввійшли під користувачем ${cookies.username} <button id="logoutButton" class="btn btn-dark" >Вийти</button> </p>
                <h3>Курс валют:</h3>
                <p>${currenciesString}</p>
                <h3>Баланс на аккаунті:</h3>
                <p id="grn">${balanceInHryvnias}грн</p>
                <p id="usd">${balanceInDollars}$</p>
                <p id="eur">${balanceInEuros}€</p>
                `
            );

            res.writeHead(200, { "Content-Type": "text/html; charset=utf-8" });
            res.end(htmlString);
          } catch (parseError) {
            res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
            res.end("Internal Server Error");
          }
        });
      }
    });
  } else if (req.method === "POST" && path === "/pupils/sytnyk/add") {
    let body = "";
    req.on("data", (chunk) => {
      body += chunk.toString();
    });
    req.on("end", () => {
      const postData = decodeURIComponent(body);
      const addText = postData.split("=")[1];
      fs.readFile("db.json", "utf8", (err, jsonData) => {
        if (err) {
          res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
          res.end("Internal Server Error");
          return;
        }
        try {
          const dbData = JSON.parse(jsonData);
          dbData.string.push(addText);
          fs.writeFile("db.json", JSON.stringify(dbData), (err) => {
            if (err) {
              res.writeHead(500, {
                "Content-Type": "text/plain; charset=utf-8",
              });
              res.end("Internal Server Error");
              return;
            }
            res.writeHead(302, { Location: "/pupils/sytnyk/" }); // перенаправляем обратно на главную страницу
            res.end();
          });
        } catch (parseError) {
          res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
          res.end("Internal Server Error");
        }
      });
    });
  } else if (req.method === "POST" && path === "/pupils/sytnyk/delete") {
    let body = "";
    req.on("data", (chunk) => {
      body += chunk.toString();
    });
    req.on("end", () => {
      const postData = decodeURIComponent(body);
      const addText = postData.split("=")[1];
      const indexToDelete = addText - 1;
      fs.readFile("db.json", "utf8", (err, jsonData) => {
        if (err) {
          res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
          res.end("Internal Server Error");
          return;
        }
        try {
          const dbData = JSON.parse(jsonData);
          if (indexToDelete !== 0) {
            dbData.string.splice(indexToDelete, 1);
          }

          fs.writeFile("db.json", JSON.stringify(dbData), (err) => {
            if (err) {
              res.writeHead(500, {
                "Content-Type": "text/plain; charset=utf-8",
              });
              res.end("Internal Server Error");
              return;
            }
            res.writeHead(302, { Location: "/pupils/sytnyk/" });
            res.end();
          });
        } catch (parseError) {
          res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
          res.end("Internal Server Error");
        }
      });
    });
  } else if (path === "/pupils/sytnyk/login") {
    fs.readFile("login.html", (err, data) => {
      if (err) {
        res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
        res.end("Internal Server Error");
      } else {
        fs.readFile("db.json", "utf8", (err, jsonData) => {
          if (err) {
            res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
            res.end("Internal Server Error");
            return;
          }
          try {
            const dbData = JSON.parse(jsonData);
            const listItems = dbData.string
              .map((item, index) => `<li>${index + 1}. ${item}</li>`)
              .join("");
            const htmlString = data
              .toString()
              .replace(
                `<p id="db"></p>`,
                `<p id="db">Зміст бази данних:</p><ul>${listItems}</ul>`
              );

            res.writeHead(200, { "Content-Type": "text/html; charset=utf-8" });
            res.end(htmlString);
          } catch (parseError) {
            res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
            res.end("Internal Server Error");
          }
        });
      }
    });
  } else if (path === "/pupils/sytnyk/changer") {
    const { currency, amount, operation } = parsedUrl.query;

    const filename = "db.json";

    readJSONFile(filename, (err, jsonData) => {
      if (err) {
        res.writeHead(500, { "Content-Type": "text/plain" });
        res.end("Internal Server Error");
        return;
      }

      try {
        let resultInHryvnias = 0;
        let resultInDollars = 0;
        let resultInEuros = 0;
        const currencyArray = jsonData.currensyToHryvnias;
        const currencyNow = currencyArray.find(
          (element) => element.currensy === currency.toUpperCase()
        );
        let userArray = jsonData.user.find(
          (element) => element.name === cookies.username
        );
        let grn = Number(userArray.balanceInHryvnias);
        let usd = Number(userArray.balanceInDollars);
        let eur = Number(userArray.balanceInEuros);

        switch (operation) {
          case "buy":
            resultInHryvnias = grn - currencyNow.buy * Number(amount);
            if (currency === "usd") {
              resultInDollars = usd + Number(amount);
            } else if (currency === "eur") {
              resultInEuros = eur + Number(amount);
            }

            if (currency === "usd") {
              resultInDollars = usd + Number(amount);
            } else if (currency === "eur") {
              resultInEuros = eur + Number(amount);
            }
            break;
          case "sell":
            resultInHryvnias = grn + currencyNow.sell * amount;
            if (currency === "usd") {
              resultInDollars = usd - Number(amount);
            } else if (currency === "eur") {
              resultInEuros = eur - Number(amount);
            }
            break;
          default:
            break;
        }

        let updatedJsonData = JSON.parse(JSON.stringify(jsonData));

        let userIndex = updatedJsonData.user.findIndex(
          (element) => element.name === cookies.username
        );

        switch (operation) {
          case "buy":
            updatedJsonData.user[userIndex].balanceInHryvnias =
              resultInHryvnias;
            if (currency === "usd") {
              updatedJsonData.user[userIndex].balanceInDollars =
                resultInDollars;
            } else if (currency === "eur") {
              updatedJsonData.user[userIndex].balanceInEuros = resultInEuros;
            }
            break;
          case "sell":
            updatedJsonData.user[userIndex].balanceInHryvnias +=
              resultInHryvnias;
            break;
          default:
            break;
        }

        fs.writeFile("db.json", JSON.stringify(updatedJsonData), (err) => {
          if (err) {
            res.writeHead(500, {
              "Content-Type": "text/plain; charset=utf-8",
            });
            res.end("Internal Server Error");
            return;
          }
          res.writeHead(302, { Location: "/pupils/sytnyk/" });
          res.end();
        });
      } catch (parseError) {
        res.writeHead(500, { "Content-Type": "text/plain" });
        res.end("Internal Server Error");
      }
    });
  } else if (path === "/pupils/sytnyk/loginForm") {
    let body = "";
    req.on("data", (chunk) => {
      body += chunk.toString();
    });

    req.on("end", () => {
      const postData = querystring.parse(body);
      const filename = "db.json";

      readJSONFile(filename, (err, jsonData) => {
        if (err) {
          res.writeHead(500, { "Content-Type": "text/plain" });
          res.end("Internal Server Error");
          return;
        }

        try {
          const user = jsonData.user.find(
            (u) =>
              u.name === postData.username_login &&
              u.password === hash(postData.password_login)
          );
          if (user) {
            setUserAndRedirect(res, "/pupils/sytnyk/", user);
          } else if (u.password !== hash(postData.password_login)) {
            res.end(`Ви ввели неправильний пароль `);
          } else {
            res.writeHead(404, { "Content-Type": "text/plain" });
            res.end(
              `Користувача з ім'ям ${postData.username_login} не знайдено`
            );
          }
        } catch (parseError) {
          res.writeHead(500, { "Content-Type": "text/plain" });
          res.end("Internal Server Error");
        }
      });
    });
  } else if (path === "/pupils/sytnyk/register") {
    let body = "";
    req.on("data", (chunk) => {
      body += chunk.toString();
    });

    req.on("end", () => {
      const postData = querystring.parse(body);
      const filename = "db.json";

      fs.readFile(filename, "utf8", (err, data) => {
        if (err) {
          console.error("Error reading file:", err);
          return;
        }

        // Parse existing JSON data
        let jsonData = JSON.parse(data);

        // Add new user data to JSON object
        const newUser = {
          name: postData.username_reg,
          password: hash(postData.password_reg),
          balanceInHryvnias: "10000",
          balanceInDollars: "0",
          balanceInEuros: "0",
        };
        jsonData.user.push(newUser);
        const newData = JSON.stringify(jsonData, null, 2);
        fs.writeFile(filename, newData, (err) => {
          if (err) {
            res.writeHead(500, {
              "Content-Type": "text/plain; charset=utf-8",
            });
            res.end("Internal Server Error");
            return;
          }
          setUserAndRedirect(res,"/pupils/sytnyk/",newUser)
          res.end();
        });
      });
    });
  } else {
    res.end(`blabla ${path}`);
  }
});

const PORT = process.env.PORT || 3000;

server.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
