const fs = require("fs");

function readJSONFile(filename, callback) {
  fs.readFile(filename, "utf8", (err, data) => {
    if (err) {
      console.error("Ошибка при чтении файла:", err);
      return callback(err);
    }

    try {
      const jsonData = JSON.parse(data);
      callback(null, jsonData);
    } catch (parseErr) {
      console.error("Ошибка при парсинге JSON:", parseErr);
      callback(parseErr);
    }
  });
}

module.exports = {
  readJSONFile,
};
