const http = require("http");
const url = require("url");
const fs = require("fs");
const querystring = require("querystring");
const crypto = require("crypto");
const { readJSONFile } = require("./functions.js");

function hash(password) {
  const hash = crypto.createHash("sha256");
  hash.update(password);
  return hash.digest("hex");
}

function setUserAndRedirect(res, location, user) {
  res.writeHead(302, {
    Location: location,
    "Set-Cookie": `username=${user.name}; Max-Age=3600; Path=/`,
  });
  res.end(`${user.name} `);
}

const server = http.createServer((req, res) => {
  const path = url.parse(req.url, true).pathname;
  const parsedUrl = url.parse(req.url, true);
  const cookieHeader = req.headers.cookie;

  const cookies = {};
  if (cookieHeader) {
    cookieHeader.split(";").forEach((cookie) => {
      const parts = cookie.split("=");
      const name = parts.shift().trim();
      const value = decodeURI(parts.join("="));
      cookies[name] = value;
    });
  }

  if (req.method === "GET" && path === "/pupils/sytnyk/") {
    if (!cookies.username) {
      res.writeHead(302, { Location: "/pupils/sytnyk/login" });
      res.end();
      return;
    }
    fs.readFile("test.html", (err, data) => {
      if (err) {
        res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
        res.end("Internal Server Error");
      } else {
        fs.readFile("db.json", "utf8", (err, jsonData) => {
          if (err) {
            res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
            res.end("Internal Server Error");
            return;
          }
          try {
            const dbData = JSON.parse(jsonData);

            const userElement = dbData.user.find(
              (element) => element.name === cookies.username
            );
            const userBallance = userElement.ballance
            const productsString = userElement.products
              .map((product) => {
                return `Назва товару: ${product.productName}<br> Ціна: ${product.price}<br> Зарезервовано: ${product.reseved}<br><br>`;
              })
              .join("\n");

            const htmlString = data.toString().replace(
              `<p id="db"></p>`,
              `<p id="db">Зараз ви ввійшли під користувачем ${cookies.username} <button id="logoutButton" class="btn btn-dark" >Вийти</button> </p>
              <h3>Ваш баланс:</h3>
              ${userBallance}гривень
              <h3>Товари, що ви замовили:</h3>
                ${productsString}
                `
            );

            res.writeHead(200, { "Content-Type": "text/html; charset=utf-8" });
            res.end(htmlString);
          } catch (parseError) {
            res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
            res.end("Internal Server Error");
          }
        });
      }
    });
  } else if (path === "/pupils/sytnyk/login") {
    fs.readFile("login.html", (err, data) => {
      if (err) {
        res.writeHead(500, { "Content-Type": "text/plain; charset=utf-8" });
        res.end("Internal Server Error");
      } 
    });
  } else if (path === "/pupils/sytnyk/sell") {
    const { name, amount } = parsedUrl.query;

    const filename = "db.json";

    readJSONFile(filename, (err, jsonData) => {
      if (err) {
        res.writeHead(500, { "Content-Type": "text/plain" });
        res.end("Internal Server Error");
        return;
      }

      try {
        const user = jsonData.user.find(
          (element) => element.name === cookies.username
        );
        const userBallance = user.ballance
        const userProducts = user.products;

        const productIndex = userProducts.findIndex(
          (product) => product.productName.toLowerCase() === name.toLowerCase()
        );
        if (productIndex !== -1) {
          const product = userProducts[productIndex];
          const totalPrice = product.price * Number(amount);


          const NewData = JSON.parse(JSON.stringify(jsonData));

          NewData.user.find(
            (element) => element.name === cookies.username
          ).ballance += totalPrice;
  

          NewData.user.find(
            (element) => element.name === cookies.username
          ).products[productIndex].reseved -= Number(amount);

          fs.writeFile(filename, JSON.stringify(NewData, null, 2), (err) => {
            if (err) {
              res.writeHead(500, {
                "Content-Type": "text/plain; charset=utf-8",
              });
              res.end("Internal Server Error");
              return;
            }
            res.writeHead(302, { Location: "/pupils/sytnyk/" });
            res.end();
          });
        } else {
          res.end(`aaaaaa`);
        }
      } catch (error) {
        console.error(error);
        res.writeHead(500, { "Content-Type": "text/plain" });
        res.end("Internal Server Error 2");
      }
    });
  } else if (path === "/pupils/sytnyk/loginForm") {
    let body = "";
    req.on("data", (chunk) => {
      body += chunk.toString();
    });

    req.on("end", () => {
      const postData = querystring.parse(body);
      const filename = "db.json";

      readJSONFile(filename, (err, jsonData) => {
        if (err) {
          res.writeHead(500, { "Content-Type": "text/plain" });
          res.end("Internal Server Error");
          return;
        }

        try {
          const user = jsonData.user.find(
            (u) =>
              u.name === postData.username_login &&
              u.password === hash(postData.password_login)
          );
          if (user) {
            setUserAndRedirect(res, "/pupils/sytnyk/", user);
          } else if (u.password !== hash(postData.password_login)) {
            res.end(`Ви ввели неправильний пароль `);
          } else {
            res.writeHead(404, { "Content-Type": "text/plain" });
            res.end(
              `Користувача з ім'ям ${postData.username_login} не знайдено`
            );
          }
        } catch (parseError) {
          res.writeHead(500, { "Content-Type": "text/plain" });
          res.end("Internal Server Error");
        }
      });
    });
  } else if (path === "/pupils/sytnyk/register") {
    let body = "";
    req.on("data", (chunk) => {
      body += chunk.toString();
    });

    req.on("end", () => {
      const postData = querystring.parse(body);
      const filename = "db.json";

      fs.readFile(filename, "utf8", (err, data) => {
        if (err) {
          console.error("Error reading file:", err);
          return;
        }
        let jsonData = JSON.parse(data);

        const newUser = {
          name: postData.username_reg,
          password: hash(postData.password_reg),
          ballance: 500,
          products: [
            {
              productName: "Стіл",
              price: 20,
              reseved: 10,
            },
            {
              productName: "Стул",
              price: 15,
              reseved: 5,
            },
            {
              productName: "Чашка",
              price: 2,
              reseved: 50,
            },
          ],
        };

        jsonData.user.push(newUser);
        const newData = JSON.stringify(jsonData, null, 2);
        fs.writeFile(filename, newData, (err) => {
          if (err) {
            res.writeHead(500, {
              "Content-Type": "text/plain; charset=utf-8",
            });
            res.end("Internal Server Error");
            return;
          }
          setUserAndRedirect(res, "/pupils/sytnyk/", newUser);
          res.end();
        });
      });
    });
  } else {
    res.end(`URL ${path}`);
  }
});

const PORT = process.env.PORT || 3000;

server.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
