const http = require('http');
const url = require('url');
const fs = require('fs');

// файл 'database.txt'
// Формат файлу: username:password:balance

const server = http.createServer((req, res) => {
    const parsedUrl = url.parse(req.url, true);
    const path = parsedUrl.pathname;
    const headers = req.headers;

    if (path === 'https://prg.oit.dp.ua/pupils/kiselev/' && req.method === 'GET') {
        // Перевірка автентифікації користувача
        const auth = headers['authorization'];
        if (!auth) {
            res.writeHead(401, { 'WWW-Authenticate': 'Basic realm="Secure Area"' });
            res.end('Access denied');
            return;
        }

        const [username, password] = Buffer.from(auth.split(' ')[1], 'base64').toString().split(':');
        fs.readFile('database.txt', 'utf8', (err, data) => {
            if (err) {
                res.writeHead(500);
                res.end('Server error');
                return;
            }

            const users = data.split('\n');
            const userRecord = users.find(record => record.startsWith(username + ':' + password));
            if (userRecord) {
                const balance = userRecord.split(':')[2];
                res.writeHead(200, { 'Content-Type': 'application/json' });
                res.end(JSON.stringify({ success: true, balance: balance }));
            } else {
                res.writeHead(401);
                res.end('Invalid credentials');
            }
        });
    } else {
        res.writeHead(404);
        res.end('Not found');
    }
});

server.listen(3000, () => {
    console.log('Сервер запущено на порту 3000');
});