const sqlite3 = require('sqlite3').verbose();
const path = require('path');

const dbFile = path.join(__dirname, '..', 'database.db');

const ff = () => {
    const db = new sqlite3.Database(dbFile);
    return new Promise((resolve, reject) => {
        db.all('SELECT * FROM students', (err, rows) => {
            if (err) {
                reject('Error retrieving table data');
            } else {
                let content = '<table border="1"><tr><th>ID</th><th>Name</th><th>Age</th><th>Grade</th></tr>';
                rows.forEach(row => {
                    content += `<tr><td>${row.id}</td><td>${row.name}</td><td>${row.age}</td><td>${row.grade}</td></tr>`;
                });
                content += '</table>';
                resolve(content);
            }
        });
        db.close();
    });
};

module.exports = (query) => ff().then(result => result).catch(err => `<p>${err}</p>`);

