const http = require('http');
const fs = require('fs');
const url = require('url');
const process = require('process');

const hostname = '127.0.0.1';
const port = 3000;

const server = http.createServer(async (req, res) => {
    res.statusCode = 200;
    res.setHeader('Content-Type', 'text/html;charset=utf-8');

    const urlObject = url.parse(req.url, true);
    const queryObject = urlObject.query;

    console.log("Received request for:", req.url);
    console.log("Parsed query parameters:", queryObject);

    if (req.url.endsWith("/favicon.ico")) {
        res.end();
    } else {
        let path = urlObject.pathname.split("/");
        let modName = path[path.length - 1] === "" ? path[path.length - 2] : path[path.length - 1];
        if (modName === "") {
            res.end(`modName=="${modName}"`);
        } else {
            const modPath = `./${modName}/${modName}.js`;
            if (fs.existsSync(modPath)) {
                let mod = require(modPath);
                if (typeof mod.ff === 'function') {
                    try {
                        console.log(`Calling function 'ff' from module: ${modPath} with params:`, queryObject);
                        let result = await mod.ff(queryObject).catch(error => {
                            console.error(error);
                            return `Error processing request: ${error.message}`;
                        });
                        console.log("Result from 'ff':", result);
                        res.end(result);
                    } catch (err) {
                        console.error(err);
                        res.end(`Error processing request: ${err.message}`);
                    }
                } else {
                    res.end(`Function ff not found in module: "${modPath}"`);
                }
            } else {
                res.end(`Wrong path: "${modPath}"`);
            }
        }
    }
});

server.listen(port, hostname, () => {
    console.log(`Server running at http://${hostname}:${port}/`);
});
