const http = require('http');
const fs = require('fs');
const url = require('url');

const hostname = '127.0.0.3';
const port = 3000;

const gradeHolder = "!==grade==!";
const errorHolder = "!==error==!";

function page(error) { 
    const page = fs.readFileSync("1.html", 'utf8');
    const db = JSON.parse(fs.readFileSync("db.json", 'utf8'));
    let grade = '';
    for(let i = 0; i < db.grade.length; i ++) {
        let marklist = '';
        for(let j = 0; j < db.grade[i].marklist.length; j ++) {
            marklist = marklist + `${db.grade[i].marklist[j].subject}: ${db.grade[i].marklist[j].marks.join(", ")} <br>`;
        }
        grade = grade + `<b>${db.grade[i].name}'s marks:</b> <br> ${marklist}`
    }
    return page.replace(gradeHolder, grade).replace(errorHolder, error);

}
const server = http.createServer((req, res) => {
    res.writeHead(200, {'Content-Type': 'text/html'});

    let requestUrl = req.url;

    if (requestUrl === '/pupils/ens/' || requestUrl === '/') {
        res.end(page(""));
    } else if(requestUrl.includes("/pupils/ens/mark")){
        const queryObject = url.parse(req.url, true).query;
        const name = queryObject.name;
        const subject = queryObject.subject;
        const mark = Number(queryObject.mark);

        const db = JSON.parse(fs.readFileSync("db.json", 'utf8'));

        let error = '';
        let exist = false;
        for(let i = 0; i < db.grade.length; i ++) {
            if(db.grade[i].name == name){
                exist = true;
                for(let j = 0; j < db.grade[i].marklist.length; j ++) {
                    if(db.grade[i].marklist[j].subject == subject) {
                        exist = true;
                        if(mark <= 12 && mark >= 1){
                            db.grade[i].marklist[j].marks.push(mark);
                        } else {
                            error = `Mark must beb between 1 and 12`;
                        } 
                    }
                }
            }
        }
        if(!exist) {
            error = `There is not such student or subject`;
        }
        fs.writeFileSync("db.json", JSON.stringify(db));
        res.end(page(error));

    } else if (requestUrl === "/pupils/ens/favicon.ico") {
        ;
    } else {
        res.end("Invalid URL");
    }
}
);

server.listen(port, hostname, () => {
    console.log(`Server running at http://${hostname}:${port}/`);
});
