const http = require('http');
const fs = require('fs');
const path = require('path');

http.createServer((req, res) => {
  if (req.method === 'GET' && req.url === '/pupils/tereshchenko/') {
    fs.readFile('./index.html', 'utf8', (err, data) => {
      if (err) {
        res.writeHead(500);
        return res.end('Error loading index.html');
      }
      res.writeHead(200, { 'Content-Type': 'text/html' });
      res.end(data);
    });
  } else if (req.method === 'GET' && req.url === '/pupils/tereshchenko/attendance') {
    fs.readFile('./attendance.json', 'utf8', (err, data) => {
      if (err) {
        res.writeHead(500);
        return res.end('Error loading attendance.json');
      }
      res.writeHead(200, { 'Content-Type': 'application/json' });
      res.end(data);
    });
  } else if (req.method === 'POST' && req.url === '/pupils/tereshchenko/update-attendance') {
    let body = '';
    req.on('data', chunk => {
      body += chunk.toString();
    });
    req.on('end', () => {
      const attendanceData = JSON.parse(body);
      fs.writeFile('./attendance.json', JSON.stringify(attendanceData, null, 2), 'utf8', err => {
        if (err) {
          res.writeHead(500);
          return res.end('Error updating attendance.json');
        }
        res.writeHead(200, { 'Content-Type': 'application/json' });
        res.end(JSON.stringify({ message: 'Data updated successfully' }));
      });
    });
  } else {
    res.writeHead(404);
    res.end();
  }
}).listen(3000, () => console.log('Server running on port 3000'));
