const express = require("express");
const app = express();
const port = 3000;

const path = require("path");

app.get("/script.js", (req, res) => {
  res.setHeader("Content-Type", "text/javascript");
  res.sendFile(path.join(__dirname, "script.js"));
});

app.get("/", (req, res) => {
    res.sendFile(__dirname + "/index.html");
  });

app.get("/change", (req, res) => {
    const input = req.query.input;
  
    console.log("Input: " + input);
  
    const inputSplit = input.split(" ");
  
    if (inputSplit.length >= 2) {
        const number = parseInt(inputSplit[0].trim());
        const sentence = inputSplit.slice(1).join(" ");
  
      const fs = require("fs");
      fs.readFile("database.txt", "utf8", (err, data) => {
        if (err) {
          console.error(err);
          res.send("Something went wrong");
        } else {
          console.log("Data from file: " + data);
  
          const dataSplit = data.split("\n");
  
            for (let i = 0; i < dataSplit.length; i++) {
                const currentSentence = dataSplit[i];
            
                const currentSentenceNoPunctuation = currentSentence.replace(/[.,!?]/g, "");
            
                const currentSentenceSplit = currentSentenceNoPunctuation.split(" ");
            
                if (currentSentenceSplit.length === number) {
                const punctuation = currentSentence.charAt(currentSentence.length - 1);
            
                dataSplit[i] = sentence + punctuation;
                }
            }
            
            const newData = dataSplit.join("\n") + "\n";
  
          console.log("New data: " + newData);
  
          fs.writeFile("new_database.txt", newData, (err) => {
            if (err) {
              console.error(err);
              res.send("Something went wrong");
            } else {
              console.log("The exchange was successful");
              res.send("The exchange was successful");
            }
          });
        }
      });
    } else {
      console.error("Invalid input");
      res.send("Invalid input");
    }
  });  

app.listen(port, () => {
  console.log(`Server running on port ${port}`);
});