const fs = require("fs");
const http = require("http");
const stream = require("stream");
let isDebug = process.env.RUN_TYPE !== undefined && process.env.RUN_TYPE.trim() == "debug";


/** @typedef {Object} ParsedURL
 *  @property {string[]} body
 *  @property {[string,string][]} getParams
 * @returns {ParsedURL} 
 * */
function parseURL(URL) {
    if (isDebug && (URL.length < 2 || URL[1] != "p")){ // local server
        return {
            body: URL.slice(1).replace(/\?.*/,"").replace(/\#.*/,"").split("/").filter(v=>v.length!=0),
            getParams: URL.slice(1).includes("?") ? URL.slice(1).replace(/.*\?/,"").replace(/\#.*/,"").split("&").map(v => v.split("=")).filter(v=>v.length==2&&v[0].length!=0&&v[1].length!=0) : []
        };
    } else if (!isDebug && URL.length >= 2 && URL[1] == "p") {
        return {
            body: URL.slice(16).replace(/\?.*/,"").replace(/\#.*/,"").split("/").filter(v=>v.length!=0),
            getParams: URL.slice(16).includes("?") ? URL.slice(16).replace(/.*\?/,"").replace(/\#.*/,"").split("&").map(v => v.split("=")).filter(v=>v.length==2&&v[0].length!=0||v[1].length!=0) : []
        };
    } else {
        throw new Error("enviroment setup error");
    }
}

module.exports.parseURL = parseURL;

/**
 * 
 * @param {string} delimeter 
 * @param {string[]} objectNames 
 * @param {{}[]} csva
 * @param {string} path
 */
function writeCSVA(delimeter, objectNames, csva, path) {
    console.log(csva);
    let string = "";
    string += `${delimeter}\n`;
    string += objectNames.reduce((p,c,i,a) => i==0?c:p+delimeter+c,"");
    string += `\n`;
    string += csva.reduce(
        (p,c,i,a) => 
            p + new Array(objectNames.length).fill(0).map((_,i,a) => c[objectNames[i]]).join()
            +"\n"
        ,"");
    fs.writeFileSync(path,string);
}

/**
 * 
 * @param {string} delimeter 
 * @param {string[]} objectNames 
 * @param {{}[]} csva
 * @param {string} path
 */
function writeDatabase(delimeter, objectNames, csva, path) {
    path = "database/" + path;
    writeCSVA(delimeter,objectNames,csva,path);
}

module.exports.writeDatabase = writeDatabase;


/**
 * 
 * @param {string} csva 
 * @returns {[string,string[],{}[]]}
 */
function parseCSVA(csva) {
    let lines = csva.split(/\r?\n/g);
    let delimiter = lines[0];
    console.log(`Delimiter: |${delimiter}|`);
    let objectNames = lines[1].split(delimiter);
    console.log(`Object names: |${objectNames}|`);
    let result = [];
    for(let i = 2; i < lines.length; i++) {
        let objects = lines[i].split(delimiter);
        result[i-2] = {};
        for (let j = 0; j < objects.length; j++) {
            let objectNameId = Math.min(j,objectNames.length-1);
            if (j<=objectNames.length-1) {
                result[i-2][objectNames[j]] = objects[j];
            } else {
                if(!(result[i-2]["other"] && result[i-2]["other"].length)) {
                    result[i-2]["other"] = [];
                }
                result[i-2]["other"].push(objects[j]);
            }
        }
    }
    return [
        delimiter,
        objectNames,
        result
    ];
}

function getDatabase(path) {
    if (typeof path == "undefined") {
        throw new Error("No path provided");
    }
    let s = fs.readFileSync("database/" + path).toString();
    return parseCSVA(s);
}

module.exports.getDatabase = getDatabase;


async function resoulveRoute(req,res,routes) {
    res.setHeader("Content-Type", "text/html");
    /** @type {ParsedURL} */
    let parsed_url;
    let debugInfo;
    debugInfo = `<hr><table> ${req.rawHeaders.map((v,i,_) => i%2==0?`<tr><td>${v}</td>`:`<td>${v}</td></tr>`).join('')} </table><p>URL: ${JSON.stringify(req.url)}</p><p>Method: ${JSON.stringify(req.method)}</p> <p>Parsed URL: ${JSON.stringify(parsed_url)}</p>`;
    try {
        console.log(req.url);
        parsed_url = parseURL(req.url);
        debugInfo = `<hr><table> ${req.rawHeaders.map((v,i,_) => i%2==0?`<tr><td>${v}</td>`:`<td>${v}</td></tr>`).join('')} </table><p>URL: ${JSON.stringify(req.url)}</p><p>Method: ${JSON.stringify(req.method)}</p> <p>Parsed URL: ${JSON.stringify(parsed_url)}</p>`;
    } catch (e) {
        res.end(`${e.message} \n ${e.stack} \n ${e.cause} \n ${debugInfo}`);
        return;
    }

    let route = routes.filter(v => {
        if (v.path.length != parsed_url.body.length)
            return false;
        for (let i = 0; i < v.path.length; i++) {
            if (v.path[i] != parsed_url.body[i]) {
                return false;
            }
        }
        return true;
    })[0];
    if (typeof route == "undefined") {
        let file = fs.readFileSync("files/404.html");
        res.end(file);
        return;
    }

    if (typeof route.staticContent != "undefined") {
        let staticStream = fs.createReadStream("files/" + route.staticContent, {});
        const result = new stream.Transform({
            readableObjectMode: true,

            transform(chunk, encoding, callback) {
                let chunkStr = chunk.toString();
                let newline = chunkStr.lastIndexOf("\n");
                [chunkStr,remainder] = [this.remainder + chunkStr.substring(0,newline), chunkStr.substring(newline)];
                let regex = /(?<=[^\\])\%.+\%(?=[^\\])/g;
                let match;
                while ((match = regex.exec(chunkStr)) !== null) {
                    let replacement = match[0];
                    if (typeof route.replace != "undefined") {
                        route.replace.filter(v => v[0] == replacement)[0][1]();
                    }
                }
                
                this.remainder = remainder;
                this.push(chunk);
                
                callback();
            }
        });
        staticStream.pipe(result).pipe(res);
    } else if (typeof route.dynamicContent != "undefined") {
        (route.dynamicContent)(req,res,parsed_url);
    }
}

module.exports.resoulveRoute = resoulveRoute;