const fs = require("fs");
const { URL } = require('url');


/** @argument {import("mysql").Connection} connection */
function server(req,res,url,connection) {
    if(url.search.length == 0) {
        res.statusCode = 200;
        res.setHeader('Content-Type', 'text/html; charset=utf-8');
        res.end(fs.readFileSync("public/CreateTableFromFilePrompt.html"));
    } else {
        /// possible values: "create", "createWithExamples", "show"
        let name = url.searchParams.get("requestType");
        if (name == "create" || name == "createWithExamples") {
            let withexamples = false;
            if(name=="createWithExamples") withexamples = true;
        
            let [queryCreateTable,queryInsertExampleValues,_] = fs.readFileSync("./DB.TXT").toString().split(/\r?\n/);
            connection.query(queryCreateTable, (err,r) => {
                let id=r.insertId;
                if (err!=null) {
                    res.statusCode = 500;
                    res.setHeader('Content-Type', 'text/plain; charset=utf-8');
                    res.end("Помилка сервера! SQL запит 1 не обробився.");
                    return;
                }
                if (withexamples) {
                    connection.query(queryInsertExampleValues, (err,r) => {
                        if (err!=null) {
                            res.statusCode = 500;
                            res.setHeader('Content-Type', 'text/plain; charset=utf-8');
                            res.end("Помилка сервера! SQL запит 2 не обробився.");
                            return;
                        }
                        res.statusCode = 200;
                        res.setHeader('Content-Type', 'text/plain; charset=utf-8');
                        res.end(`Створено таблицю! (з прикладами!!!)`);
                    });
                } else {
                    res.statusCode = 200;
                    res.setHeader('Content-Type', 'text/plain; charset=utf-8');
                    res.end(`Створено таблицю!`);
                }
            });
        } else if(name == "show") {
            let [_,__,selectAll] = fs.readFileSync("./DB.TXT").toString().split(/\r?\n/);
            connection.query(selectAll, (err,r) => {
                if(err!=null) {
                    res.statusCode = 500;
                    res.setHeader('Content-Type', 'text/plain; charset=utf-8');
                    res.end("Помилка сервера! SQL запит 3 не обробився.");
                    return;
                }
                res.statusCode = 200;
                res.setHeader('Content-Type', 'text/plain; charset=utf-8');
                res.end(JSON.stringify(r,null,2));
            })
        } else {
            res.statusCode = 400;
            res.setHeader('Content-Type', 'text/plain; charset=utf-8');
            res.end("Помилка клієнта! Сервер не зрозумів name.");
            return;
        }
    }
}

exports.server = server;