const fs = require("fs");
const mysql = require("mysql");

function createTable(config, callback) {
  const filePath = "./DB.txt";
  console.log(filePath);

  fs.readFile(filePath, "utf8", (err, sql) => {
    console.log(err, sql);
    if (err) {
      callback(err);
      return;
    }

    const connection = mysql.createConnection(config);

    connection.connect((err) => {
      console.log(err);
      if (err) {
        callback(err);
        return;
      }

      connection.query(sql, (err) => {
        connection.end();
        callback(err);
      });
    });
  });
}

exports.createTable = createTable;
