const http = require("http");
const fs = require("fs");
const url = require("url");
const process = require("process");

const modCreate = require('./module/createTable');
const createTable = modCreate.createTable;
const modShow = require('./module/showTable');
const showTable = modShow.showTable;

const hostname = "127.0.0.1";
const port = 3000;

const config = {
  host: "localhost",
  user: "khizha_dzhun",
  password: "pEdxer-rupnam-3pikji",
  database: "khizha_dzhun",
};

const server = http.createServer((req, res) => {
  // res.statusCode = 200;
  // res.setHeader("Content-Type", "text/html;charset=utf-8");

  const urlObject = url.parse(req.url, true);
  const queryObject = urlObject.query;
  
  if (req.url.endsWith("/favicon.ico"));
  else if (req.url.endsWith("/module")) {
    let path = urlObject.pathname.split("/");
    let modName =
      path[path.length - 1] == ""
        ? path[path.length - 2]
        : path[path.length - 1];
    if (modName == "") res.end(`modName=="${modName}"`);
    else {
      if (fs.existsSync(`./${modName}/${modName}.js`)) {
        let mod = require(`./${modName}/${modName}.js`);
        res.end(mod.ff(queryObject));
      } else res.end(`Wrong path: "./${modName}/"`);
    }
  }
  else if (req.url.endsWith("/createTable")) {
    createTable(config, (err) => {
      if (err) {
        res.writeHead(500, { "Content-Type": "text/plain" });
        res.end("Error creating table: " + err.message);
      } else {
        res.writeHead(200, { "Content-Type": "text/plain" });
        res.end("Table created successfully.");
      }
    });
  }
  else if (req.url.endsWith("/showTable")) {
    showTable(config, (err, results) => {
      if (err) {
        res.writeHead(500, { "Content-Type": "text/plain" });
        res.end("Error showing table: " + err.message);
      } else {
        res.writeHead(200, { "Content-Type": "application/json" });
        res.end(JSON.stringify(results));
      }
    });
  }
});

server.listen(port, hostname, () => {
  console.log(`Server running at http://${hostname}:${port}/`);
});
