const http = require('http');
const fs = require('fs');
const path = require('path');
const querystring = require('querystring');

const hostname = '127.0.0.1';
const port = 3000;
const dbPath = path.join(__dirname, 'text.txt');

const server = http.createServer((req, res) => {
    if (req.method === 'GET') {
        fs.readFile('index.html', (err, htmlContent) => {
            if (err) throw err;

            fs.readFile(dbPath, { encoding: 'utf-8' }, (err, data) => {
                if (err) {
                    res.writeHead(500, {'Content-Type': 'text/plain'});
                    res.end('Failed to read database');
                    return;
                }

                const lines = data.split('\n').filter(line => line.trim() !== '');
                const listItems = lines.map(line => `<li>${line}</li>`).join('');

                const finalHtml = htmlContent.toString().replace('</body>', `<h2>Database Contents</h2><ul>${listItems}</ul></body>`);

                res.writeHead(200, {'Content-Type': 'text/html'});
                res.end(finalHtml);
            });
        });
    } else if (req.method === 'POST') {
        let body = '';
        req.on('data', chunk => {
            body += chunk.toString();
        });
        req.on('end', () => {
            const postData = querystring.parse(body);

            if (req.url === '/pupils/tereshchenko/add') {
                const newLine = postData.newLine + '\n';
                fs.appendFile(dbPath, newLine, err => {
                    if (err) throw err;
                    res.writeHead(302, { 'Location': '/pupils/tereshchenko/' });
                    res.end();
                });
            } else if (req.url === '/pupils/tereshchenko/delete') {
                fs.readFile(dbPath, { encoding: 'utf-8' }, (err, data) => {
                    if (err) throw err;
                    let lines = data.trim().split('\n');
                    lines.pop();
                    fs.writeFile(dbPath, lines.join('\n') + '\n', err => {
                        if (err) throw err;
                        res.writeHead(302, { 'Location': '/pupils/tereshchenko/' });
                        res.end();
                    });
                });
            }
        });
    }
});

server.listen(port, hostname, () => {
    console.log(`Server running at http://${hostname}:${port}/`);
});
