const http = require('http');
const url = require('url');
const fs = require('fs');
const mysql = require('mysql');
const customModule = require('./mod/2024-05-17');

const hostname = '127.0.0.1';
const port = 3000;

const server = http.createServer((req, res) => {
    res.statusCode = 200;
    res.setHeader('Content-Type', 'text/plain');

    const urlObject = url.parse(req.url, true);
    const path = urlObject.pathname;

    if (path === '/') {
        createTable((success) => {
            const responseMessage = success ? "Таблиця створена успішно" : "Таблиця не була створена, перевірте введені данні";
            res.end(responseMessage);
        });
    } else {
        res.end('Invalid path');
    }
});

function createTable(callback) {
    const connection = mysql.createConnection({
        host: '127.0.0.1',
        user: 'khiza_sorkina',
        password: 'fujqIq-pizvek-fivru6',
        database: 'khiza_sorkina'
    });

    connection.connect((error) => {
        if (error) {
            console.error('Error connecting to MySQL database:', error);
            callback(false);
        } else {
            console.log('Connected to MySQL database!');
            fs.readFile('table.txt', 'utf8', (err, data) => {
                if (err) {
                    console.error('Error reading table.txt:', err);
                    callback(false);
                } else {
                    const statements = data.split(';');
                    executeStatements(connection, statements, callback);
                }
            });
        }
    });
}

function executeStatements(connection, statements, callback) {
    let success = true;
    statements.forEach((statement) => {
        if (statement.trim()) {
            connection.query(statement, (error) => {
                if (error) {
                    console.error('Error executing query:', error);
                    success = false;
                }
            });
        }
    });

    connection.end(() => {
        callback(success);
    });
}

server.listen(port, hostname, () => {
    console.log(`Server running at http://${hostname}:${port}/`);
});