const http = require('http');
const url = require('url');
const fs = require('fs');
const hostname = '127.0.0.1';
const port = 3000;

const server = http.createServer((req, res) => {
  res.statusCode = 200;
  res.setHeader('Content-Type', 'text/plain');

  const urlObject = url.parse(req.url, true);
  const queryObject = urlObject.query;

  if (req.url.endsWith("/favicon.ico")) {
    res.end();
  } else {
    let path = urlObject.pathname.split("/");
    let modName = path[path.length - 1] === "" ? path[path.length - 2] : path[path.length - 1];
    if (modName === "") {
      res.end(`modName=="${modName}"`);
    } else {
      if (fs.existsSync(`./${modName}/${modName}.js`)) {
        let mod = require(`./${modName}/${modName}.js`);
        let modRes = mod.ff(queryObject);
        res.end(modRes);
      } else {
        res.end(`Wrong path: "./${modName}/"`);
      }
    }
  }
});

server.listen(port, hostname, () => {
  console.log(`Server running at http://${hostname}:${port}/`);
});