const result = document.getElementById("result");

document.querySelector("form").addEventListener("submit", (event) => {
    event.preventDefault();
    result.innerHTML = "";
    const input = document.querySelector("input").value;

    fetch("/change?input=" + input)
        .then((response) => {
            if (response.ok) {
                return response.text();
            } else {
                throw new Error("Something went wrong");
            }
        })
        .then((data) => {
            result.innerHTML = data;
        })
        .catch((error) => {
            result.innerHTML = error.message;
        });
});