const fs = require("fs");
const http = require("http");
const stream = require("stream");
const {getDatabase,parseURL,writeDatabase,resoulveRoute} = require("../supplementaries");
const {loginResult} = require("./common_login_logic");

let journal_routes = [
    {
        path: [],
        staticContent: "journal/leader.html"
    },
    {
        path: ["login"],
        staticContent: "login_screen.html"
    },
    {
        path: ["loginResult"],
        dynamicContent: loginResult
    },
    {
        path: ["json_get_journal"],
        dynamicContent: json_get_journal
    },
    {
        path: ["json_add_to_journal"],
        dynamicContent: json_add_to_journal,
    },
]

function json_get_journal(req,res,parsed_url) {
    if (!checkSession(parsed_url)[0]) {return;}
    let [delimeter,names,values] = getDatabase("journal.csva");
    let pairs = [];
    values.forEach(v => {
        pairs.push([v[names[0]],v[names[1]],v[names[2]],v[names[3]]]);
    });
    res.setHeader("Content-Type","text/json");
    res.end(JSON.stringify(pairs));
}

function json_add_to_journal(req,res,parsed_url) {
        res.setHeader("Content-Type","text/json");
        let session = checkSession(parsed_url);
        if (!session[0]) {return;}
        let login = session[1];
        
        let date = parsed_url.getParams.find(v => v[0]=="date");
        let theme = parsed_url.getParams.find(v => v[0]=="theme");
        let additional = parsed_url.getParams.find(v => v[0]=="additional");
        let homework = parsed_url.getParams.find(v => v[0]=="homework");

        console.log(parsed_url.getParams);

        if (typeof date == "undefined" || typeof theme == "undefined" || typeof additional == "undefined" || typeof homework == "undefined") {
            res.end(JSON.stringify({result:"error"}));
            return;
        }

        date = date[1];
        theme = theme[1];
        additional = additional[1];
        homework = homework[1];
        let [delim,names,values] = getDatabase("journal.csva");
        let obj = {};
        obj[names[0]] = date
        obj[names[1]] = theme;
        obj[names[2]] = additional;
        obj[names[3]] = homework;
        values.push(obj);
        writeDatabase(delim,names,values,"journal.csva");
}

function checkSession(parsed_url) {
    let [delimeter,names,values] = getDatabase("sessions.csva");
    let session = parsed_url.getParams.find(v => v[0]=="session");
    if (typeof session == "undefined") {
        return [false,null];
    }
    session = session[1];
    let filter = values.find(v => v[names[1]] === session);
    if (typeof filter !== "undefined") {
        return [true,filter[names[0]]];
    }
    return false;
}

module.exports.journal_routes = journal_routes;
// module.exports.loginResult = loginResult;
// module.exports.jsonMoney = jsonMoney;
// module.exports.jsonCurrentAmount = jsonCurrentAmount;
// module.exports.jsonConvert = jsonConvert;
// module.exports.checkSession = checkSession;