const fs = require("fs");
const http = require("http");
const stream = require("stream");
const {resoulveRoute} = require("./supplementaries");
const {litbank_routes} = require("./subfolders/litbank");
const {journal_routes} = require("./subfolders/journal");


let isDebug = process.env.RUN_TYPE !== undefined && process.env.RUN_TYPE.trim() == "debug";


let routes =  [

    {
        path: [],
        staticContent: "main.html"
    },

    ...litbank_routes.map(v => {v.path = ["bank"].concat(v.path); return v;}),
    ...journal_routes.map(v => {v.path = ["journal"].concat(v.path); return v;})
];

console.log(routes);


let s = http.createServer((req,res) => {
    resoulveRoute(req,res,routes);   
})

let port;

if(isDebug)
    port = 3000;
else
    port = process.env.PORT || 3000;



s.listen(port, () => {
  console.log(`Server is running on port ${port}`);
});
