const http = require('http');
const fs = require('fs');
const url = require('url');

const hostname = '127.0.0.3';
const port = 3000;

const placeholder = "!==paste==!";

function get_db() {
    return JSON.parse(fs.readFileSync("db.json"));
}

function parse_db(db) {
    let text = "";
    let arr = db["string"];

    for (let i = 0; i < arr.length; i++) {
        text += `${i + 1}: ${arr[i]} <br>`;
    }

    return text;
}

function default_responce() {
    let html = String(fs.readFileSync("1.html"));
    const db_test = parse_db(get_db());
    return html.replace(placeholder, db_test);
}

function fill_db(db) {
    fs.writeFileSync("db.json", JSON.stringify(db));
}

const server = http.createServer(
    (req, res) => {
        res.statusCode = 200;
        res.setHeader('Content-Type', 'text/html');
        let URL = req.url;
        console.log(URL);

        const queryObject = url.parse(URL, true).query;
        if(URL.endsWith("/favicon.ico")) {
            ;
        } else if (URL == `/pupils/ens/`) {
            let response = default_responce();
            res.end(response);

        } else if (URL.startsWith(`/pupils/ens/add`)) {
            const queryObject = url.parse(URL, true).query;
            const index = Number(queryObject.number) - 1;
            const string = queryObject.string;
            
            let db = get_db();
            db["string"].splice(index, 0, string);

            fill_db(db);

            let response = default_responce();
            response = `string ${queryObject.number} added successfully <br>` + response;
            res.end(response);
        } else if (URL.startsWith(`/pupils/ens/delete`)) {

            const queryObject = url.parse(URL, true).query;
            const index = Number(queryObject.number) - 1;

            let db = get_db();
            db["string"].splice(index, 1);

            fill_db(db);

            let response = default_responce();
            response = `string ${queryObject.number} deleted successfully <br>` + response;
            res.end(response);
        }
    }
);

server.listen(port, hostname, () => {
    console.log(`Server running at http://${hostname}:${port}/`);
});
