const http = require('http');
const fs = require('fs');
const url = require('url');

const hostname = '127.0.0.1';
const port = 3000;

const server = http.createServer((req, res) => {
    res.writeHead(200, {'Content-Type': 'text/html'});

    let requestUrl = req.url;
    console.log(`Received request for: ${requestUrl}`);

    if (requestUrl === '/pupils/ens/') {
        res.end(fs.readFileSync("1.html", 'utf8'));
    } else if(requestUrl.startsWith("/pupils/ens/contest")){
        const queryObject = url.parse(req.url, true).query;
        const contests = queryObject.contest.split(", ");

        const db = JSON.parse(fs.readFileSync("db.json", "utf-8"));
        let result = '';
        for (let key in db) {
            if (db.hasOwnProperty(key)) {
                if(contests.includes(db[key].name)){
                    result = result + `${db[key].name}: ${db[key].data}<br>`
                }
            }
        }
        if(result === ""){
            result = "There are not such contests"
        }
        res.end(result);
    } else if (requestUrl.endsWith("/favicon.ico")) {
        
    } else {
        res.end("Invalid URL");
    }
});

server.listen(port, hostname, () => {
    console.log(`Server running at http://${hostname}:${port}/`);
});